<?php defined('SYSPATH') or die('No direct script access.');

class Task_Serverstats_Update_CountClientsSphinx extends Minion_Task
{
    
    const UPDATE_PERIOD = 60;
    
	protected function _execute(array $params)
    {
        Task_Helper::createWorker('Serverstats:Update:CountClientsSphinx', $this);
	}

    public function Worker(GearmanJob $job)
    {
        $serverstat = ORM::factory('Serverstat', 'CountClientsSphinx');
        
        if ( null === $serverstat->updated_at || time() - strtotime($serverstat->updated_at) > self::UPDATE_PERIOD )
        {
            $clientTotalInfo = $this->getClientTotalInfo();
            $countClientsSphinx = $clientTotalInfo['total_found'];
            if (0 == $countClientsSphinx) {
                $countClientsSphinx = '<span class="text-danger">' . $countClientsSphinx . '</span>';
            }
            
            Model_Serverstat::setStat('CountClientsSphinx', $countClientsSphinx);
        }
    }
    
    protected function getClientTotalInfo()
    {
        $sphinxql = new SphinxQL();
        $result = $sphinxql->new_query()
            ->add_index('clients')
            ->limit(0)
            ->executeOrFail();
        
        return $result['total_info'];
    }
    
    
    
}